/*	$OpenBSD: tfork_thread.S,v 1.3 2013/07/05 21:10:50 miod Exp $	*/

/*
 * Copyright (c) 2005, Miodrag Vallat
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
 * STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN
 * ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

#include "SYS.h"

/*
 * int __tfork_thread(const struct __tfork *param, size_t psize, void (*func)(void *), void *arg);
 */
ENTRY(__tfork_thread, R2|R3)
	/*
	 * Save thread creation arguments into registers.
	 */
	movl	12(%ap), %r2	/* func */
	movl	16(%ap), %r3	/* arg */

	__DO_SYSCALL(__tfork)
	jcs	9f

	cmpl	%r0, $0
	beql	1f

	/*
	 * In parent process: just return.
	 */
	ret

1:
	/*
	 * In child process: switch stack, invoke function, then exit.
	 * Note that since we can not pass a register to calls, we need
	 * to waste 4 bytes of stack in every thread.
	 */
	pushl	%r2		/* func */
	pushl	%r3		/* arg */
	calls	$1, *4(%sp)	/* func */

	__DO_SYSCALL(__threxit)

9:
	/*
	 * system call failed.
	 */
	jmp	_C_LABEL(__cerror)
